"use client"

import { useApplicationWorkflow } from "@/hooks/use-application-workflow";
import { cn } from "@/lib/utils";
import { ComponentWithClassName } from "@/types/utils";
import { TransformedStatewideService } from "../type/transformers";
import { WorkflowButton } from "./workflow.button";

export function WorkflowButtonUpdate({ data, className }: ComponentWithClassName<{ data: NonNullable<TransformedStatewideService> }>) {
  const { setWorkflow } = useApplicationWorkflow()

  return (
    <WorkflowButton
      step="UPDATE_SERVICE"
      variant="outline"
      size={"sm"}
      onClick={() => setWorkflow({
        __tag: "UPDATE_SERVICE",
        id: data.id,
      })}
      className={cn(
        className
      )}
      aria-label={`Open dialog to edit service details for ${data.agencyId} with name ${data.alias}`}
    />
  )
}

